function P82_iv
% Problem 8.2 :	The growth/decay of population of animal species
% iv. period-doubling

% make series of r between 2.90 and 3.60 
% with step size of 0.001
r=2.90:0.001:3.60;
% Set initial population
x0=0.5;
% Define number of different final populations
n=zeros(1,length(r));
% Counter for number of period doubling happening
j=1;
% Define color setr
col={'r' ; 'b' ; 'g' ; 'm'};
% define figure
figure(1);
% Simulation with different r
for i=1:length(r)
    % get 10000 values of final population
    % 1. Simulation up to 40000 secs
    % 2. Collect populations for next 10000 secs
    %    as final population.
    xn=LogiEqn(r(i),x0);
    
    % Discard numbers below 0.001
    xf=fix(xn*1000);
    % Extract unique populations
    xf=unique(xf);
    % Count number of unique populations
    n(i)=length(xf);
    if i>1
       % if period-doubling happens, display r
       if n(i)~=n(i-1)
           fprintf('at r=%f, number of population =%d\n', ...
               r(i),n(i));
           % if the first 4 period-dobling, plot n vs. xn
           if j<=4
               subplot(2,2,j);
               plot([end-31:end],xn,[col{j} '.']);
               axis tight; grid on;
               set(gca,'FontSize',16);
               xlabel('\bfYear (n)');
               ylabel('\bfNormalized Population (x_n)');
               title(['Number of period-doubling =' num2str(n(i))]);
               j=j+1;
           end
       end
    % For starting point,
    else
       fprintf('at r=%f, number of population =%d\n', ...
           r(i),n(i));
    end
end
% Plot r vs. number of unique populations
figure(2);
plot(r,n,'r-'); 
grid on; axis tight;
xlabel('\bfThe combined rate for reproduction and starvation (a.u.)');
ylabel('\bfNumber of Unique normalized populations');
title('\bfNumber of Uniqie normalized population for 2.9<=r<=3.6');
end

function y=LogiEqn(r,x)
% Calculate quadratic reccureance relations
% x_n+1=r*x_n

% Calculate population for first 40000 years
for i=1:40000
    xn=r*x.*(1-x);
    x=xn;
end
% Define variable to store population for next 10000 years 
y=zeros(length(x),10000);
% Calculate population for next 10000 years
for i=1:10000
    xn=r*x.*(1-x);
    x=xn;
    y(:,i)=xn;
end
end 
    
    
